#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_UniqueDatabaseConstraintViolatedException : BaseTest
	{
		private static readonly string TestConflictingColumnName = UnitTestUtil.GetRandomString( 255 );
		private static readonly string TestMessage = UnitTestUtil.GetRandomString( 512 );
		private static readonly Exception TestException = new Exception();

		[Test]
		public void Ctor_Parameterless_Pass()
		{
			Assert.IsNotNull( new Common.UniqueDatabaseConstraintViolatedException() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Parameterless_Fail() {}	

		[Test]
		public void Ctor_StringMsg_Pass()
		{
			AssertNotNullAndTestMessage( new Common.UniqueDatabaseConstraintViolatedException( TestMessage ) );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_StringMsg_Fail() {}

		[Test]
		public void Ctor_Full_Pass()
		{
            Common.UniqueDatabaseConstraintViolatedException _xcp = new Common.UniqueDatabaseConstraintViolatedException(TestMessage, TestException);
			
			AssertNotNullAndTestMessage( _xcp );
			Assert.AreEqual( TestException, _xcp.InnerException );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Full_Fail() {}

		private void AssertNotNullAndTestMessage( Common.UniqueDatabaseConstraintViolatedException xcpToTest )
		{
			Assert.IsNotNull( xcpToTest );
			Assert.AreEqual( TestMessage, xcpToTest.Message );
		}

		[Test]
		public void ConflictingDbColumnName_Pass_1()
		{
            Common.UniqueDatabaseConstraintViolatedException _xcp = new Common.UniqueDatabaseConstraintViolatedException();
			_xcp.ConflictingDbColumnName = TestConflictingColumnName;

			Assert.AreEqual( TestConflictingColumnName, _xcp.ConflictingDbColumnName );
		}

		[Test]
		public void ConflictingDbColumnName_Pass_2()
		{
            Assert.IsNull(new Common.UniqueDatabaseConstraintViolatedException().ConflictingDbColumnName);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ConflictingDbColumnName_Fail() {}
	}
}

#endif 
